
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x = m.addVars(5, lb=0.0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, names=["x0", "x1", "x2", "x3", "x4"])
r = m.addVars(5, lb=0.0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, names=["r0", "r1", "r2", "r3", "r4"])


# Set objective
m.setObjective(4.17 * x[0] + 5.07 * x[1] + 1.76 * x[2] + 5.66 * x[3] + 8.71 * x[4], gp.GRB.MINIMIZE)

# Add constraints

# Resource constraints
m.addConstr(r[0] == 11 * x[0] + 9 * x[1] + 16 * x[2] + 13 * x[3] + 17 * x[4], "fat_constraint")
m.addConstr(r[1] == 5 * x[0] + 17 * x[1] + 1 * x[2] + 20 * x[3] + 13 * x[4], "cost_constraint")
m.addConstr(r[2] == 19 * x[0] + 14 * x[1] + 18 * x[2] + 5 * x[3] + 14 * x[4], "calcium_constraint")
m.addConstr(r[3] == 12 * x[0] + 13 * x[1] + 13 * x[2] + 17 * x[3] + 12 * x[4], "sourness_constraint")
m.addConstr(r[4] == 11 * x[0] + 8 * x[1] + 3 * x[2] + 11 * x[3] + 8 * x[4], "tastiness_constraint")


m.addConstr(r[0] <= 344)
m.addConstr(r[1] <= 189)
m.addConstr(r[2] <= 330)
m.addConstr(r[3] <= 229)
m.addConstr(r[4] <= 230)


# Other constraints, translated from the JSON's "constraints"
for constraint_str in json_data["constraints"]:
    m.addConstr(eval(constraint_str))  # eval() is used here for simplicity, but be cautious in real-world applications


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

