
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
hank = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hank")
peggy = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy")
ringo = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo")


# Set objective function
model.setObjective(6*george**2 + 7*george*hank + 5*george*peggy + george*ringo + 3*hank**2 + 9*hank*peggy + 8*hank*ringo + 7*peggy**2 + 2*peggy*ringo + 4*ringo**2 + 6*george + 5*hank + 2*peggy + 2*ringo, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(3*george <= 111, "c0")
model.addConstr(11*hank <= 111, "c1")
model.addConstr(12*peggy <= 111, "c2")
model.addConstr(13*ringo <= 111, "c3")
model.addConstr((11*hank)**2 + (12*peggy)**2 >= 25, "c4")
model.addConstr((11*hank)**2 + (13*ringo)**2 >= 17, "c5")
model.addConstr(3*george + 11*hank >= 14, "c6")
model.addConstr(3*george + 13*ringo >= 16, "c7")
model.addConstr(3*george + 11*hank + 12*peggy + 13*ringo >= 16, "c8")
model.addConstr(-10*george + 4*ringo >= 0, "c9")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('George:', george.x)
    print('Hank:', hank.x)
    print('Peggy:', peggy.x)
    print('Ringo:', ringo.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

