
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)  # hours worked by George
    x2 = model.addVar(name='x2', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
    x3 = model.addVar(name='x3', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)  # hours worked by Peggy
    x4 = model.addVar(name='x4', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo

    # Set the objective function
    model.setObjective(6*x1**2 + 7*x1*x2 + 5*x1*x3 + x1*x4 + 3*x2**2 + 9*x2*x3 + 8*x2*x4 + 7*x3**2 + 2*x3*x4 + 4*x4**2 + 6*x1 + 5*x2 + 2*x3 + 2*x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 == 3)
    model.addConstr(x2 == 11)
    model.addConstr(x3 == 12)
    model.addConstr(x4 == 13)
    model.addConstr(x2**2 + x3**2 >= 25)
    model.addConstr(x2**2 + x4**2 >= 17)
    model.addConstr(x1 + x2 >= 14)
    model.addConstr(x1 + x4 >= 16)
    model.addConstr(x1 + x2 + x3 + x4 >= 16)
    model.addConstr(-10*x1 + 4*x4 >= 0)

    # Update the model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
