
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="x0", lb=0)  # milligrams of vitamin B3
    x1 = m.addVar(name="x1", lb=0)  # milligrams of vitamin B2
    x2 = m.addVar(name="x2", lb=0)  # milligrams of magnesium


    # Set objective function
    m.setObjective(8.18 * x0 + 7.28 * x1 + 9.58 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.58 * x0 + 2.19 * x2 >= 33)
    m.addConstr(0.58 * x0 + 2.05 * x1 + 2.19 * x2 >= 30)
    m.addConstr(2.81 * x0 + 0.07 * x2 >= 59)
    m.addConstr(1.34 * x1 + 0.07 * x2 >= 36)
    m.addConstr(2.58 * x0 + 0.1 * x1 >= 24)
    m.addConstr(0.1 * x1 + 0.1 * x2 >= 58)
    m.addConstr(2.58 * x0 + 0.1 * x2 >= 67)
    m.addConstr(2.05 * x1 + 2.19 * x2 <= 69)
    m.addConstr(0.58 * x0 + 2.19 * x2 <= 53)
    m.addConstr(0.58 * x0 + 2.05 * x1 + 2.19 * x2 <= 117)
    m.addConstr(1.34 * x1 + 0.07 * x2 <= 189)
    m.addConstr(2.81 * x0 + 1.34 * x1 <= 182)
    m.addConstr(2.81 * x0 + 0.07 * x2 <= 155)
    m.addConstr(2.81 * x0 + 1.34 * x1 + 0.07 * x2 <= 153)
    m.addConstr(0.1 * x1 + 0.1 * x2 <= 186)
    m.addConstr(2.58 * x0 + 0.1 * x2 <= 87)
    m.addConstr(1.05 * x0 + 2.59 * x1 <= 157)
    m.addConstr(2.59 * x1 + 1.29 * x2 <= 96)
    m.addConstr(1.05 * x0 + 2.59 * x1 + 1.29 * x2 <= 96)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
