
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B3
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B2
    x3 = model.addVar(name="x3", lb=0)  # milligrams of magnesium

    # Define the objective function
    model.setObjective(8.18 * x1 + 7.28 * x2 + 9.58 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.58 * x1 + 2.19 * x3 >= 33)
    model.addConstr(0.58 * x1 + 2.05 * x2 + 2.19 * x3 >= 30)
    model.addConstr(2.81 * x1 + 0.07 * x3 >= 59)
    model.addConstr(1.34 * x2 + 0.07 * x3 >= 36)
    model.addConstr(2.58 * x1 + 0.1 * x2 >= 24)
    model.addConstr(0.1 * x2 + 0.1 * x3 >= 58)
    model.addConstr(2.58 * x1 + 0.1 * x3 >= 67)
    model.addConstr(2.05 * x2 + 2.19 * x3 <= 69)
    model.addConstr(0.58 * x1 + 2.19 * x3 <= 53)
    model.addConstr(0.58 * x1 + 2.05 * x2 + 2.19 * x3 <= 117)
    model.addConstr(1.34 * x2 + 0.07 * x3 <= 189)
    model.addConstr(2.81 * x1 + 1.34 * x2 <= 182)
    model.addConstr(2.81 * x1 + 0.07 * x3 <= 155)
    model.addConstr(2.81 * x1 + 1.34 * x2 + 0.07 * x3 <= 153)
    model.addConstr(0.1 * x2 + 0.1 * x3 <= 186)
    model.addConstr(2.58 * x1 + 0.1 * x3 <= 87)
    model.addConstr(2.58 * x1 + 0.1 * x2 + 0.1 * x3 <= 87)
    model.addConstr(1.05 * x1 + 2.59 * x2 <= 157)
    model.addConstr(2.59 * x2 + 1.29 * x3 <= 96)
    model.addConstr(1.05 * x1 + 2.59 * x2 + 1.29 * x3 <= 96)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B3: {x1.varValue}")
        print(f"Milligrams of vitamin B2: {x2.varValue}")
        print(f"Milligrams of magnesium: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
