
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_work_hours")

    # Create variables
    laura = m.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")
    bobby = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")
    peggy = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy")
    paul = m.addVar(vtype=gp.GRB.CONTINUOUS, name="paul")
    mary = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mary")


    # Set objective function
    m.setObjective(1*laura + 2*bobby + 9*peggy + 9*paul + 1*mary, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(21*laura + 23*bobby >= 114, "c1")
    m.addConstr(26*peggy + 15*paul >= 89, "c2")
    m.addConstr(23*bobby + 4*mary >= 124, "c3")
    m.addConstr(15*paul + 4*mary >= 51, "c4")
    m.addConstr(21*laura + 4*mary >= 146, "c5")
    m.addConstr(21*laura + 23*bobby + 26*peggy + 15*paul + 4*mary >= 146, "c6")
    m.addConstr(2*bobby - 4*mary >= 0, "c7")
    m.addConstr(21*laura + 15*paul + 4*mary <= 577, "c8")
    m.addConstr(21*laura + 23*bobby + 15*paul <= 708, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
