
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Laura', lb=0)
    x2 = model.addVar(name='hours_worked_by_Bobby', lb=0)
    x3 = model.addVar(name='hours_worked_by_Peggy', lb=0)
    x4 = model.addVar(name='hours_worked_by_Paul', lb=0)
    x5 = model.addVar(name='hours_worked_by_Mary', lb=0)

    # Define the objective function
    model.setObjective(1*x1 + 2*x2 + 9*x3 + 9*x4 + 1*x5, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(21*x1 + 23*x2 >= 114)
    model.addConstr(26*x3 + 15*x4 >= 89)
    model.addConstr(23*x2 + 4*x5 >= 124)
    model.addConstr(15*x4 + 4*x5 >= 51)
    model.addConstr(21*x1 + 4*x5 >= 146)
    model.addConstr(21*x1 + 23*x2 + 26*x3 + 15*x4 + 4*x5 >= 146)
    model.addConstr(2*x2 - 4*x5 >= 0)
    model.addConstr(21*x1 + 15*x4 + 4*x5 <= 577)
    model.addConstr(21*x1 + 23*x2 + 15*x4 <= 708)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Laura: ', x1.varValue)
        print('Hours worked by Bobby: ', x2.varValue)
        print('Hours worked by Peggy: ', x3.varValue)
        print('Hours worked by Paul: ', x4.varValue)
        print('Hours worked by Mary: ', x5.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
