
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
laura_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
bobby_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby_hours")


# Set objective function
m.setObjective(3*laura_hours**2 + 7*laura_hours*bobby_hours + 7*bobby_hours**2 + 4*laura_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*laura_hours + 2*bobby_hours >= 25, "work_quality_min")
m.addConstr(8*laura_hours - 10*bobby_hours >= 0, "work_ratio")
m.addConstr(5*laura_hours**2 + 2*bobby_hours**2 <= 73, "work_quality_squared_max")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
elif m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:\nLaura's hours: {laura_hours.x}\nBobby's hours: {bobby_hours.x}")
    print(f"Objective value: {m.objVal}")

    
else:
    print(f"Optimization terminated with status: {m.status}")

