
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name='hours_worked_by_Laura', lb=-GRB.INFINITY)
x2 = m.addVar(name='hours_worked_by_Bobby', lb=-GRB.INFINITY)

# Set the objective function
m.setObjective(3*x1**2 + 7*x1*x2 + 7*x2**2 + 4*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 2*x2 >= 25, name='total_work_quality')
m.addConstr(8*x1 - 10*x2 >= 0, name='hours_constraint')
m.addConstr((5*x1)**2 + (2*x2)**2 <= 58, name='quality_rating_squared')

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Laura: {x1.x}')
    print(f'Hours worked by Bobby: {x2.x}')
else:
    print('No optimal solution found')
