
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)  # Laura
x2 = m.addVar(name="hours_worked_by_Bobby", lb=0)  # Bobby

# Objective function
m.setObjective(3*x1**2 + 7*x1*x2 + 7*x2**2 + 4*x1, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 2*x2 >= 25, name="work_quality_rating")
m.addConstr(8*x1 - 10*x2 >= 0, name="work_hours_constraint")
m.addConstr(x1**2 + x2**2 <= 58, name="work_quality_rating_squared")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {x1.varValue}")
    print(f"Hours worked by Bobby: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
