
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
slices_pizza = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="slices_pizza")


# Set objective function
m.setObjective(8.42*fruit_salads**2 + 6.59*fruit_salads*pickles + 4.82*fruit_salads*chicken_breasts + 7.22*fruit_salads*slices_pizza + 1.9*pickles**2 + 5.91*pickles*chicken_breasts + 4.85*chicken_breasts**2 + 4.59*slices_pizza**2 + 5.64*pickles + 4.36*slices_pizza, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(22*pickles + 24*slices_pizza <= 464, "protein_constraint1")
m.addConstr(10*fruit_salads + 3*chicken_breasts <= 205, "protein_constraint2")
m.addConstr(10*fruit_salads + 3*chicken_breasts + 24*slices_pizza <= 356, "protein_constraint3")
m.addConstr(10*fruit_salads + 22*pickles + 3*chicken_breasts + 24*slices_pizza <= 494, "protein_constraint4") # Using the upper bound provided in the prompt


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

