
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="fruit_salads", lb=0)  # No lower bound specified, assuming 0
x2 = m.addVar(name="pickles", lb=0)     # No lower bound specified, assuming 0
x3 = m.addVar(name="chicken_breasts", lb=0)  # No lower bound specified, assuming 0
x4 = m.addVar(name="slices_of_pizza", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(8.42*x1**2 + 6.59*x1*x2 + 4.82*x1*x3 + 7.22*x1*x4 + 
               1.9*x2**2 + 5.91*x2*x3 + 4.85*x3**2 + 4.59*x4**2 + 
               5.64*x2 + 4.36*x4, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(10*x1 + 22*x2 + 3*x3 + 24*x4 <= 356)
m.addConstr(22*x2 + 24*x4 <= 464)
m.addConstr(10*x1 + 3*x3 <= 205)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Fruit Salads: ", x1.varValue)
    print("Pickles: ", x2.varValue)
    print("Chicken Breasts: ", x3.varValue)
    print("Slices of Pizza: ", x4.varValue)
else:
    print("The model is infeasible or unbounded.")
