
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="engineer_platoons")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")

    # Set objective function
    m.setObjective(7.58 * x0 + 5.44 * x1 + 5.56 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * x0 + 11 * x1 >= 21, "c1")
    m.addConstr(11 * x1 + 10 * x2 >= 9, "c2")
    m.addConstr(2 * x0 + 11 * x1 + 10 * x2 >= 18, "c3")
    m.addConstr(13 * x1 + 8 * x2 >= 23, "c4")
    m.addConstr(3 * x0 + 8 * x2 >= 19, "c5")
    m.addConstr(3 * x0 + 13 * x1 + 8 * x2 >= 19, "c6")
    m.addConstr(14 * x0 + 14 * x2 >= 9, "c7")
    m.addConstr(14 * x0 + 14 * x1 + 14 * x2 >= 9, "c8")
    m.addConstr(11 * x0 + 1 * x1 >= 26, "c9")
    m.addConstr(11 * x0 + 10 * x2 >= 11, "c10")
    m.addConstr(11 * x0 + 1 * x1 + 10 * x2 >= 13, "c11")
    m.addConstr(-2 * x0 + 5 * x1 >= 0, "c12")
    m.addConstr(-2 * x1 + 1 * x2 >= 0, "c13")
    m.addConstr(11 * x1 + 10 * x2 <= 32, "c14")
    m.addConstr(2 * x0 + 11 * x1 <= 45, "c15")
    m.addConstr(13 * x1 + 8 * x2 <= 45, "c16")
    m.addConstr(11 * x0 + 1 * x1 <= 43, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
