
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="engineer_platoons", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(7.58 * x0 + 5.44 * x1 + 5.56 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x0 + 11 * x1 >= 21)
    model.addConstr(11 * x1 + 10 * x2 >= 9)
    model.addConstr(2 * x0 + 11 * x1 + 10 * x2 >= 18)
    model.addConstr(13 * x1 + 8 * x2 >= 23)
    model.addConstr(3 * x0 + 8 * x2 >= 19)
    model.addConstr(3 * x0 + 13 * x1 + 8 * x2 >= 19)
    model.addConstr(14 * x0 + 14 * x2 >= 9)
    model.addConstr(14 * x0 + 14 * x1 + 14 * x2 >= 9)
    model.addConstr(11 * x0 + x1 >= 26)
    model.addConstr(11 * x0 + 10 * x2 >= 11)
    model.addConstr(11 * x0 + x1 + 10 * x2 >= 13)
    model.addConstr(-2 * x0 + 5 * x1 >= 0)
    model.addConstr(-2 * x1 + x2 >= 0)
    model.addConstr(11 * x1 + 10 * x2 <= 32)
    model.addConstr(2 * x0 + 11 * x1 <= 45)
    model.addConstr(13 * x1 + 8 * x2 <= 45)
    model.addConstr(11 * x0 + x1 <= 43)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Engineer platoons: ", x0.varValue)
        print("Light infantry companies: ", x1.varValue)
        print("CBRN platoons: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
