
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B3")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_D")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_C")


    # Set objective function
    m.setObjective(4*x0 + 1*x1 + 6*x2 + 2*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 3*x1 + 5*x2 + 1*x3 <= 151, "c0")
    m.addConstr(6*x0 + 3*x1 >= 21, "c1")
    m.addConstr(5*x2 + 1*x3 >= 17, "c2")
    m.addConstr(3*x1 + 1*x3 >= 31, "c3")
    m.addConstr(3*x1 + 5*x2 >= 24, "c4")
    m.addConstr(6*x0 + 3*x1 + 1*x3 >= 23, "c5")
    m.addConstr(6*x0 + 3*x1 + 5*x2 + 1*x3 >= 23, "c6")
    m.addConstr(1*x1 - 2*x2 >= 0, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
