
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # milligrams of vitamin B3
    x2 = model.addVar(name='x2', lb=0)  # milligrams of vitamin D
    x3 = model.addVar(name='x3', lb=0)  # milligrams of vitamin B4
    x4 = model.addVar(name='x4', lb=0)  # milligrams of vitamin C

    # Objective function: minimize 4*x1 + x2 + 6*x3 + 2*x4
    model.setObjective(4*x1 + x2 + 6*x3 + 2*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x1 >= 6)
    model.addConstr(3*x2 >= 3)
    model.addConstr(5*x3 >= 5)
    model.addConstr(x4 >= 1)
    model.addConstr(6*x1 + 3*x2 >= 21)
    model.addConstr(5*x3 + x4 >= 17)
    model.addConstr(3*x2 + x4 >= 31)
    model.addConstr(3*x2 + 5*x3 >= 24)
    model.addConstr(6*x1 + 3*x2 + x4 >= 23)
    model.addConstr(6*x1 + 3*x2 + 5*x3 + x4 >= 23)
    model.addConstr(x2 - 2*x3 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of vitamin B3: {x1.varValue}')
        print(f'milligrams of vitamin D: {x2.varValue}')
        print(f'milligrams of vitamin B4: {x3.varValue}')
        print(f'milligrams of vitamin C: {x4.varValue}')
        print(f'Objective: {model.objVal}')
    else:
        print('No optimal solution found.')

optimize_vitamins()
