
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(2*x0 + 3*x1 + x2 + 2*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 8*x2 >= 36)
m.addConstr(8*x2 + 7*x3 >= 16)
m.addConstr(3*x1 + 7*x3 >= 20)
m.addConstr(6*x0 + 3*x1 >= 27)
m.addConstr(6*x0 + 3*x1 + 7*x3 >= 35)
m.addConstr(6*x0 + 3*x1 + 8*x2 + 7*x3 >= 35)
m.addConstr(6*x0 + 13*x3 >= 29)
m.addConstr(8*x1 + 13*x3 >= 22)
m.addConstr(8*x1 + 5*x2 >= 34)
m.addConstr(6*x0 + 5*x2 + 13*x3 >= 37)
m.addConstr(6*x0 + 8*x1 + 5*x2 >= 37)
m.addConstr(6*x0 + 5*x2 + 13*x3 >= 30)
m.addConstr(6*x0 + 8*x1 + 5*x2 >= 30)
m.addConstr(6*x0 + 8*x1 + 5*x2 + 13*x3 >= 30)
m.addConstr(7*x2 + 8*x3 >= 29)
m.addConstr(x1 + 8*x3 >= 34)
m.addConstr(10*x0 + 7*x2 + 8*x3 >= 35)
m.addConstr(10*x0 + x1 + 7*x2 >= 35)
m.addConstr(10*x0 + 7*x2 + 8*x3 >= 21)
m.addConstr(10*x0 + x1 + 7*x2 >= 21)
m.addConstr(10*x0 + x1 + 7*x2 + 8*x3 >= 21)
m.addConstr(4*x1 - 5*x3 >= 0)
m.addConstr(9*x0 - 9*x1 >= 0)
m.addConstr(3*x1 + 7*x3 <= 137)
m.addConstr(6*x0 + 3*x1 <= 112)
m.addConstr(3*x1 + 8*x2 <= 138)
m.addConstr(6*x0 + 8*x2 <= 127)
m.addConstr(6*x0 + 7*x3 <= 128)
m.addConstr(6*x0 + 8*x2 + 7*x3 <= 61)
m.addConstr(6*x0 + 3*x1 + 8*x2 <= 51)
m.addConstr(6*x0 + 5*x2 <= 116)
m.addConstr(8*x1 + 5*x2 <= 140)
m.addConstr(5*x2 + 13*x3 <= 88)
m.addConstr(10*x0 + 7*x2 + 8*x3 <= 140)
m.addConstr(10*x0 + x1 + 7*x2 <= 132)

# Resource constraints
m.addConstr(6 * x0 <= 168)
m.addConstr(6 * x0 <= 163)
m.addConstr(10 * x0 <= 143)
m.addConstr(3 * x1 <= 168)
m.addConstr(8 * x1 <= 163)
m.addConstr(1 * x1 <= 143)
m.addConstr(8 * x2 <= 168)
m.addConstr(5 * x2 <= 163)
m.addConstr(7 * x2 <= 143)
m.addConstr(7 * x3 <= 168)
m.addConstr(13 * x3 <= 163)
m.addConstr(8 * x3 <= 143)



# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

