
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B5")
x2 = m.addVar(lb=0, name="milligrams_of_magnesium")
x3 = m.addVar(lb=0, name="milligrams_of_potassium")
x4 = m.addVar(lb=0, name="milligrams_of_zinc")

# Set the objective function
m.setObjective(2*x1 + 3*x2 + x3 + 2*x4, GRB.MINIMIZE)

# Define the constraints based on the given problem description
# Digestive support index constraints
m.addConstr(6*x1 + 3*x2 + 8*x3 + 7*x4 <= 168) # Total digestive support index constraint
m.addConstr(6*x1 + 8*x3 + 7*x4 >= 16) # Minimum digestive support from vitamin B5, potassium, and zinc
m.addConstr(3*x2 + 8*x3 + 7*x4 >= 36) # Minimum digestive support from magnesium, potassium, and zinc
m.addConstr(6*x1 + 3*x2 + 7*x4 >= 27) # Minimum digestive support from vitamin B5, magnesium, and zinc
m.addConstr(6*x1 + 3*x2 + 8*x3 + 7*x4 >= 35) # Total minimum digestive support index

# Immune support index constraints
m.addConstr(6*x1 + 13*x4 >= 29) # Minimum immune support from vitamin B5 and zinc
m.addConstr(8*x2 + 13*x4 >= 22) # Minimum immune support from magnesium and zinc
m.addConstr(8*x2 + 5*x3 >= 34) # Minimum immune support from magnesium and potassium
m.addConstr(6*x1 + 5*x3 + 13*x4 >= 37) # Minimum immune support from vitamin B5, potassium, and zinc

# Kidney support index constraints
m.addConstr(7*x3 + 8*x4 >= 29) # Minimum kidney support from potassium and zinc
m.addConstr(x1 + x2 + x3 + x4 >= 0) # Non-negativity constraint for all variables

# Additional constraints as per the problem description
m.addConstr(4*x2 - 5*x4 >= 0)
m.addConstr(9*x1 - 9*x2 >= 0)

# Upper bound constraints for digestive support indices
m.addConstr(3*x2 + 7*x4 <= 137) # Maximum digestive support from magnesium and zinc
m.addConstr(6*x1 + 3*x2 <= 112) # Maximum digestive support from vitamin B5 and magnesium

# Solve the model
m.optimize()

# Print the solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
