
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B5
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY)  # milligrams of magnesium
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY)  # milligrams of potassium
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY)  # milligrams of zinc

    # Objective function
    model.setObjective(2 * x0 + 3 * x1 + x2 + 2 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 8 * x2 + 7 * x3 >= 36)
    model.addConstr(8 * x2 + 13 * x3 >= 16)
    model.addConstr(3 * x1 + 7 * x3 >= 20)
    model.addConstr(6 * x0 + 3 * x1 >= 27)
    model.addConstr(6 * x0 + 3 * x1 + 7 * x3 >= 35)
    model.addConstr(6 * x0 + 3 * x1 + 8 * x2 + 7 * x3 >= 35)
    model.addConstr(6 * x0 + 13 * x3 >= 29)
    model.addConstr(8 * x1 + 13 * x3 >= 22)
    model.addConstr(8 * x1 + 5 * x2 >= 34)
    model.addConstr(6 * x0 + 5 * x2 + 13 * x3 >= 37)
    model.addConstr(6 * x0 + 8 * x1 + 5 * x2 >= 37)
    model.addConstr(6 * x0 + 5 * x2 + 13 * x3 >= 30)
    model.addConstr(6 * x0 + 8 * x1 + 5 * x2 >= 30)
    model.addConstr(6 * x0 + 8 * x1 + 5 * x2 + 13 * x3 >= 30)
    model.addConstr(7 * x2 + 8 * x3 >= 29)
    model.addConstr(x1 + 8 * x3 >= 34)
    model.addConstr(10 * x0 + 7 * x2 + 8 * x3 >= 35)
    model.addConstr(10 * x0 + x1 + 7 * x2 >= 35)
    model.addConstr(10 * x0 + 7 * x2 + 8 * x3 >= 21)
    model.addConstr(10 * x0 + x1 + 7 * x2 >= 21)
    model.addConstr(10 * x0 + x1 + 7 * x2 + 8 * x3 >= 21)
    model.addConstr(4 * x1 - 5 * x3 >= 0)
    model.addConstr(9 * x0 - 9 * x1 >= 0)
    model.addConstr(3 * x1 + 7 * x3 <= 137)
    model.addConstr(6 * x0 + 3 * x1 <= 112)
    model.addConstr(3 * x1 + 8 * x2 <= 138)
    model.addConstr(6 * x0 + 8 * x2 <= 127)
    model.addConstr(6 * x0 + 7 * x3 <= 128)
    model.addConstr(6 * x0 + 8 * x2 + 7 * x3 <= 61)
    model.addConstr(6 * x0 + 3 * x1 + 8 * x2 <= 51)
    model.addConstr(6 * x0 + 5 * x2 <= 116)
    model.addConstr(8 * x1 + 5 * x2 <= 140)
    model.addConstr(5 * x2 + 13 * x3 <= 88)
    model.addConstr(10 * x0 + 7 * x2 + 8 * x3 <= 140)
    model.addConstr(10 * x0 + x1 + 7 * x2 <= 132)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
