
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_food_cost")

# Create variables
chicken_drumsticks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")


# Set objective function
m.setObjective(1 * chicken_drumsticks + 8 * kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.86 * chicken_drumsticks + 8.95 * kiwis >= 60, "fiber_constraint1")
m.addConstr(-8 * chicken_drumsticks + 10 * kiwis >= 0, "constraint2")
m.addConstr(1.86 * chicken_drumsticks + 8.95 * kiwis <= 139, "fiber_constraint3")



# Optimize model
m.optimize()

# Check if a solution was found
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Chicken drumsticks: {chicken_drumsticks.x}')
    print(f'Kiwis: {kiwis.x}')
    print(f'Objective Value: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}')

