
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_drumsticks")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="kiwis")

# Set the objective function
m.setObjective(1*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(1.86*x1 + 8.95*x2 >= 60, "Fiber_From_Foods")
m.addConstr(-8*x1 + 10*x2 >= 0, "Complex_Constraint")
m.addConstr(1.86*x1 + 8.95*x2 <= 139, "Total_Fiber_Limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chicken Drumsticks: {x1.x}")
    print(f"Kiwis: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
