
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="chicken_drumsticks", lb=0)  # Assuming non-negative
x2 = model.addVar(name="kiwis", lb=0)  # Assuming non-negative

# Objective function
model.setObjective(x1 + 8 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(1.86 * x1 + 8.95 * x2 >= 60, name="fiber_min")
model.addConstr(1.86 * x1 >= 60, name="chicken_drumsticks_min")
model.addConstr(8.95 * x2 >= 60, name="kiwis_min")
model.addConstr(-8 * x1 + 10 * x2 >= 0, name="linear_constraint")
model.addConstr(1.86 * x1 + 8.95 * x2 <= 139, name="fiber_max")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Chicken drumsticks: ", x1.varValue)
    print("Kiwis: ", x2.varValue)
else:
    print("No solution found")
