
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
vincas = m.addVar(vtype=gp.GRB.INTEGER, name="vincas")
cucumber_vines = m.addVar(vtype=gp.GRB.INTEGER, name="cucumber_vines")
peonies = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
tulips = m.addVar(vtype=gp.GRB.INTEGER, name="tulips")

# Set objective function
m.setObjective(8.06 * vincas + 8.61 * cucumber_vines + 8.98 * peonies + 2.28 * tulips, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * vincas + 15 * tulips >= 35)
m.addConstr(8 * cucumber_vines + 15 * tulips >= 64)
m.addConstr(14 * vincas + 13 * peonies >= 70)
m.addConstr(14 * vincas + 8 * cucumber_vines >= 28)
m.addConstr(8 * cucumber_vines + 13 * peonies >= 64)
m.addConstr(13 * peonies + 15 * tulips >= 41)
m.addConstr(14 * vincas + 8 * cucumber_vines + 15 * tulips >= 73)
m.addConstr(8 * cucumber_vines + 13 * peonies + 15 * tulips >= 73)
m.addConstr(14 * vincas + 8 * cucumber_vines + 15 * tulips >= 72)
m.addConstr(8 * cucumber_vines + 13 * peonies + 15 * tulips >= 72)
m.addConstr(14 * vincas + 8 * cucumber_vines + 13 * peonies + 15 * tulips >= 72)
m.addConstr(10 * vincas + 3 * cucumber_vines >= 72)
m.addConstr(3 * cucumber_vines + 23 * peonies + 7 * tulips >= 60)
m.addConstr(10 * vincas + 3 * cucumber_vines + 23 * peonies >= 60)
m.addConstr(10 * vincas + 23 * peonies + 7 * tulips >= 60)
m.addConstr(3 * cucumber_vines + 23 * peonies + 7 * tulips >= 43)
m.addConstr(10 * vincas + 3 * cucumber_vines + 23 * peonies >= 43)
m.addConstr(10 * vincas + 23 * peonies + 7 * tulips >= 43)
m.addConstr(3 * cucumber_vines + 23 * peonies + 7 * tulips >= 67)
m.addConstr(10 * vincas + 3 * cucumber_vines + 23 * peonies >= 67)
m.addConstr(10 * vincas + 23 * peonies + 7 * tulips >= 67)
m.addConstr(10 * vincas + 3 * cucumber_vines + 23 * peonies + 7 * tulips >= 67)
m.addConstr(-2 * cucumber_vines + 4 * tulips >= 0)
m.addConstr(13 * peonies + 15 * tulips <= 196)
m.addConstr(14 * vincas + 8 * cucumber_vines <= 259)
m.addConstr(8 * cucumber_vines + 13 * peonies <= 113)
m.addConstr(14 * vincas + 8 * cucumber_vines + 13 * peonies <= 116)
m.addConstr(23 * peonies + 7 * tulips <= 170)
m.addConstr(10 * vincas + 7 * tulips <= 245)
m.addConstr(3 * cucumber_vines + 23 * peonies + 7 * tulips <= 297)
m.addConstr(10 * vincas + 23 * peonies + 7 * tulips <= 176)
m.addConstr(10 * vincas + 3 * cucumber_vines + 7 * tulips <= 288)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

