
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='vincas', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='cucumber_vines', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='peonies', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='tulips', vtype=gurobi.GRB.INTEGER)

# Set the objective function
m.setObjective(8.06 * x1 + 8.61 * x2 + 8.98 * x3 + 2.28 * x4, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * x1 >= 14)
m.addConstr(10 * x1 >= 10)
m.addConstr(8 * x2 >= 8)
m.addConstr(3 * x2 >= 3)
m.addConstr(13 * x3 >= 13)
m.addConstr(23 * x3 >= 23)
m.addConstr(15 * x4 >= 15)
m.addConstr(7 * x4 >= 7)
m.addConstr(14 * x1 + 15 * x4 >= 35)
m.addConstr(8 * x2 + 15 * x4 >= 64)
m.addConstr(14 * x1 + 13 * x3 >= 70)
m.addConstr(14 * x1 + 8 * x2 >= 28)
m.addConstr(8 * x2 + 13 * x3 >= 64)
m.addConstr(13 * x3 + 15 * x4 >= 41)
m.addConstr(14 * x1 + 8 * x2 + 15 * x4 >= 73)
m.addConstr(8 * x2 + 13 * x3 + 15 * x4 >= 73)
m.addConstr(14 * x1 + 8 * x2 + 15 * x4 >= 72)
m.addConstr(8 * x2 + 13 * x3 + 15 * x4 >= 72)
m.addConstr(14 * x1 + 8 * x2 + 13 * x3 + 15 * x4 >= 72)
m.addConstr(10 * x1 + 3 * x2 >= 72)
m.addConstr(3 * x2 + 23 * x3 + 7 * x4 >= 60)
m.addConstr(10 * x1 + 3 * x2 + 23 * x3 >= 60)
m.addConstr(10 * x1 + 23 * x3 + 7 * x4 >= 60)
m.addConstr(3 * x2 + 23 * x3 + 7 * x4 >= 43)
m.addConstr(10 * x1 + 3 * x2 + 23 * x3 >= 43)
m.addConstr(10 * x1 + 23 * x3 + 7 * x4 >= 43)
m.addConstr(3 * x2 + 23 * x3 + 7 * x4 >= 67)
m.addConstr(10 * x1 + 3 * x2 + 23 * x3 >= 67)
m.addConstr(10 * x1 + 23 * x3 + 7 * x4 >= 67)
m.addConstr(10 * x1 + 3 * x2 + 23 * x3 + 7 * x4 >= 67)
m.addConstr(-2 * x2 + 4 * x4 >= 0)
m.addConstr(13 * x3 + 15 * x4 <= 196)
m.addConstr(14 * x1 + 8 * x2 <= 259)
m.addConstr(8 * x2 + 13 * x3 <= 113)
m.addConstr(14 * x1 + 8 * x2 + 13 * x3 <= 116)
m.addConstr(23 * x3 + 7 * x4 <= 170)
m.addConstr(10 * x1 + 7 * x4 <= 245)
m.addConstr(3 * x2 + 23 * x3 + 7 * x4 <= 297)
m.addConstr(10 * x1 + 23 * x3 + 7 * x4 <= 176)
m.addConstr(10 * x1 + 3 * x2 + 7 * x4 <= 288)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Vincas: ', x1.varValue)
    print('Cucumber Vines: ', x2.varValue)
    print('Peonies: ', x3.varValue)
    print('Tulips: ', x4.varValue)
else:
    print('No solution found')
