
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("muscle_growth")

    # Create variables
    carbs = m.addVar(lb=0, name="carbs")
    protein = m.addVar(lb=0, name="protein")
    potassium = m.addVar(lb=0, name="potassium")


    # Set objective function
    m.setObjective(2.87 * carbs + 8.97 * protein + 2.78 * potassium, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3 * carbs + 7 * protein >= 10, "c0")
    m.addConstr(3 * carbs + 10 * potassium >= 17, "c1")
    m.addConstr(3 * carbs + 7 * protein + 10 * potassium >= 17, "c2")
    m.addConstr(10 * protein - 5 * potassium >= 0, "c3")
    m.addConstr(1 * carbs - 9 * protein >= 0, "c4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('carbs:', carbs.x)
        print('protein:', protein.x)
        print('potassium:', potassium.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    elif m.status == gp.GRB.UNBOUNDED:
        print('The model is unbounded.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

