
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="grams_of_carbohydrates")
x2 = m.addVar(lb=0, name="grams_of_protein")
x3 = m.addVar(lb=0, name="milligrams_of_potassium")

# Set the objective function
m.setObjective(2.87*x1 + 8.97*x2 + 2.78*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 7*x2 >= 10, "muscle_growth_index_carbs_protein")
m.addConstr(3*x1 + 10*x3 >= 17, "muscle_growth_index_carbs_potassium")
m.addConstr(3*x1 + 7*x2 + 10*x3 >= 17, "total_muscle_growth_index")
m.addConstr(10*x2 - 5*x3 >= 0, "protein_potassium_constraint")
m.addConstr(x1 - 9*x2 >= 0, "carbs_protein_constraint")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Carbohydrates: {x1.x}")
    print(f"Grams of Protein: {x2.x}")
    print(f"Milligrams of Potassium: {x3.x}")
else:
    print("No optimal solution found")
