
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="carbohydrates", lb=0)  # grams of carbohydrates
x2 = model.addVar(name="protein", lb=0)     # grams of protein
x3 = model.addVar(name="potassium", lb=0)   # milligrams of potassium

# Objective function
model.setObjective(2.87 * x1 + 8.97 * x2 + 2.78 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(3 * x1 + 7 * x2 >= 10, name="carbohydrates_protein_mgi")
model.addConstr(3 * x1 + 10 * x3 >= 17, name="carbohydrates_potassium_mgi")
model.addConstr(3 * x1 + 7 * x2 + 10 * x3 >= 17, name="total_mgi")
model.addConstr(10 * x2 - 5 * x3 >= 0, name="protein_potassium_constraint")
model.addConstr(x1 - 9 * x2 >= 0, name="carbohydrates_protein_tradeoff")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Carbohydrates: {x1.varValue}")
    print(f"Protein: {x2.varValue}")
    print(f"Potassium: {x3.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
