
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")

# Set objective function
m.setObjective(4 * green_beans + 2 * bananas + 4 * chicken_thighs + 8 * milkshakes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18 * chicken_thighs + 18 * milkshakes >= 34)
m.addConstr(19 * bananas + 18 * milkshakes >= 46)
m.addConstr(18 * green_beans + 3 * chicken_thighs >= 41)
m.addConstr(17 * green_beans + 4 * milkshakes >= 30)
m.addConstr(17 * green_beans + 11 * bananas >= 44)
m.addConstr(17 * green_beans + 11 * bananas + 4 * milkshakes >= 48)
m.addConstr(11 * bananas + 19 * chicken_thighs + 4 * milkshakes >= 48)
m.addConstr(17 * green_beans + 19 * chicken_thighs + 4 * milkshakes >= 48)
m.addConstr(17 * green_beans + 11 * bananas + 4 * milkshakes >= 59)
m.addConstr(11 * bananas + 19 * chicken_thighs + 4 * milkshakes >= 59)
m.addConstr(17 * green_beans + 19 * chicken_thighs + 4 * milkshakes >= 59)
m.addConstr(17 * green_beans + 11 * bananas + 4 * milkshakes >= 49)
m.addConstr(11 * bananas + 19 * chicken_thighs + 4 * milkshakes >= 49)
m.addConstr(17 * green_beans + 19 * chicken_thighs + 4 * milkshakes >= 49)
m.addConstr(18 * green_beans + 19 * bananas <= 148)
m.addConstr(19 * bananas + 18 * milkshakes <= 97)
m.addConstr(3 * chicken_thighs + 18 * milkshakes <= 131)
m.addConstr(19 * bananas + 3 * chicken_thighs <= 81)
m.addConstr(18 * green_beans + 3 * chicken_thighs <= 66)
m.addConstr(18 * green_beans + 19 * bananas + 3 * chicken_thighs + 18 * milkshakes <= 66)
m.addConstr(19 * chicken_thighs + 4 * milkshakes <= 125)
m.addConstr(17 * green_beans + 4 * milkshakes <= 170)
m.addConstr(11 * bananas + 4 * milkshakes <= 125)
m.addConstr(17 * green_beans + 11 * bananas + 19 * chicken_thighs <= 228)
m.addConstr(17 * green_beans + 11 * bananas + 19 * chicken_thighs + 4 * milkshakes <= 228)

# Resource constraints
m.addConstr(18 * green_beans + 19 * bananas + 3 * chicken_thighs + 18 * milkshakes <= 193)
m.addConstr(17 * green_beans + 11 * bananas + 19 * chicken_thighs + 4 * milkshakes <= 237)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

