
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="green_beans", lb=0)
x1 = m.addVar(name="bananas", lb=0)
x2 = m.addVar(name="chicken_thighs", lb=0)
x3 = m.addVar(name="milkshakes", lb=0)

# Objective function
m.setObjective(4*x0 + 2*x1 + 4*x2 + 8*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(18*x0 + 19*x1 + 3*x2 + 18*x3 <= 193)
m.addConstr(17*x0 + 11*x1 + 19*x2 + 4*x3 <= 237)
m.addConstr(3*x2 + 18*x3 >= 34)
m.addConstr(19*x1 + 18*x3 >= 46)
m.addConstr(18*x0 + 3*x2 >= 41)
m.addConstr(17*x0 + 4*x3 >= 30)
m.addConstr(17*x0 + 11*x1 >= 44)
m.addConstr(17*x0 + 11*x1 + 4*x3 >= 48)
m.addConstr(11*x1 + 19*x2 + 4*x3 >= 48)
m.addConstr(17*x0 + 19*x2 + 4*x3 >= 48)
m.addConstr(17*x0 + 11*x1 + 4*x3 >= 59)
m.addConstr(11*x1 + 19*x2 + 4*x3 >= 59)
m.addConstr(17*x0 + 19*x2 + 4*x3 >= 59)
m.addConstr(17*x0 + 11*x1 + 4*x3 >= 49)
m.addConstr(11*x1 + 19*x2 + 4*x3 >= 49)
m.addConstr(17*x0 + 19*x2 + 4*x3 >= 49)
m.addConstr(18*x0 + 19*x1 <= 148)
m.addConstr(19*x1 + 18*x3 <= 97)
m.addConstr(3*x2 + 18*x3 <= 131)
m.addConstr(19*x1 + 3*x2 <= 81)
m.addConstr(18*x0 + 3*x2 <= 66)
m.addConstr(18*x0 + 19*x1 + 3*x2 + 18*x3 <= 66)
m.addConstr(19*x2 + 4*x3 <= 125)
m.addConstr(17*x0 + 4*x3 <= 170)
m.addConstr(11*x1 + 4*x3 <= 125)
m.addConstr(17*x0 + 11*x1 + 19*x2 <= 228)
m.addConstr(17*x0 + 11*x1 + 19*x2 + 4*x3 <= 228)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Green beans: ", x0.varValue)
    print("Bananas: ", x1.varValue)
    print("Chicken thighs: ", x2.varValue)
    print("Milkshakes: ", x3.varValue)
else:
    print("The model is infeasible")
