
import gurobipy as gp

# Create a new model
m = gp.Model("MilitaryOptimization")

# Create variables
x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["Military Intelligence", "Armored", "Transportation", "Recon", "Mechanized Infantry"])

# Set objective function
m.setObjective(8.23 * x[0] + 4.69 * x[1] + 6.7 * x[2] + 6.31 * x[3] + 8.32 * x[4], gp.GRB.MINIMIZE)

# Add constraints
logistical_capacity = [15, 12, 8, 9, 24]
fuel_demand = [18, 23, 23, 18, 25]
logistical_upper_bound = 614
fuel_upper_bound = 554


m.addConstr(15 * x[0] + 8 * x[2] >= 47)
m.addConstr(12 * x[1] + 9 * x[3] >= 80)
m.addConstr(9 * x[3] + 24 * x[4] >= 114)
m.addConstr(12 * x[1] + 24 * x[4] >= 43)
m.addConstr(15 * x[0] + 12 * x[1] >= 41)
m.addConstr(12 * x[1] + 8 * x[2] >= 75)
m.addConstr(15 * x[0] + 9 * x[3] >= 41)
m.addConstr(15 * x[0] + 24 * x[4] >= 120)
m.addConstr(15 * x[0] + 12 * x[1] + 8 * x[2] + 9 * x[3] + 24 * x[4] >= 120)

m.addConstr(23 * x[1] + 25 * x[4] >= 54)
m.addConstr(18 * x[3] + 25 * x[4] >= 69)


for i in range(5):
    for j in range(i,5):
        for k in range(j,5):
            m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] >= 67)
            m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] >= 73)
            m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] <= 284)
            if i != j and j != k:
                m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] >= 84)
                m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] >= 98)
                m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] >= 102)
                m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] >= 108)
                m.addConstr(fuel_demand[i]*x[i] + fuel_demand[j]*x[j] + fuel_demand[k]*x[k] <= 243)

m.addConstr(sum(fuel_demand[i]*x[i] for i in range(5)) >= 108)


m.addConstr(6 * x[2] - x[4] >= 0)
m.addConstr(15 * x[0] + 9 * x[3] + 24 * x[4] <= 247)
m.addConstr(15 * x[0] + 12 * x[1] + 8 * x[2] <= 469)
m.addConstr(12 * x[1] + 8 * x[2] + 9 * x[3] <= 460)
m.addConstr(8 * x[2] + 9 * x[3] + 24 * x[4] <= 581)
m.addConstr(12 * x[1] + 8 * x[2] + 24 * x[4] <= 294)
m.addConstr(18 * x[3] + 25 * x[4] <= 301)
m.addConstr(23 * x[2] + 25 * x[4] <= 419)
m.addConstr(23 * x[1] + 18 * x[3] <= 326)
m.addConstr(23 * x[1] + 23 * x[2] <= 197)
m.addConstr(18 * x[0] + 18 * x[3] <= 393)
m.addConstr(23 * x[1] + 18 * x[3] + 25 * x[4] <= 257)


m.addConstr(sum(logistical_capacity[i] * x[i] for i in range(5)) <= logistical_upper_bound)
m.addConstr(sum(fuel_demand[i] * x[i] for i in range(5)) <= fuel_upper_bound)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

