
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize Organization Score")

# Create variables
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill")
ringo = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")


# Set objective function
model.setObjective(6.8 * bill + 2.31 * ringo + 1.02 * dale + 1.49 * george, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * ringo + 16 * george >= 20, "c1")
model.addConstr(14 * dale + 16 * george >= 39, "c2")
model.addConstr(16 * bill + 6 * ringo >= 30, "c3")
model.addConstr(6 * ringo + 14 * dale + 16 * george >= 29, "c4")
model.addConstr(16 * bill + 6 * ringo + 14 * dale + 16 * george >= 29, "c5")
model.addConstr(5 * ringo - 4 * george >= 0, "c6")
model.addConstr(16 * bill + 6 * ringo + 16 * george <= 128, "c7")
model.addConstr(16 * bill + 14 * dale + 16 * george <= 182, "c8")
model.addConstr(6 * ringo + 14 * dale + 16 * george <= 73, "c9")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Bill: {bill.x}")
    print(f"Ringo: {ringo.x}")
    print(f"Dale: {dale.x}")
    print(f"George: {george.x}")

elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

