
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Bill', lb=0)
    x2 = model.addVar(name='hours_worked_by_Ringo', lb=0)
    x3 = model.addVar(name='hours_worked_by_Dale', lb=0)
    x4 = model.addVar(name='hours_worked_by_George', lb=0)

    # Define the objective function
    model.setObjective(6.8 * x1 + 2.31 * x2 + 1.02 * x3 + 1.49 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x2 + 16 * x4 >= 20)
    model.addConstr(14 * x3 + 16 * x4 >= 39)
    model.addConstr(16 * x1 + 6 * x2 >= 30)
    model.addConstr(6 * x2 + 14 * x3 + 16 * x4 >= 29)
    model.addConstr(16 * x1 + 6 * x2 + 14 * x3 + 16 * x4 >= 29)
    model.addConstr(5 * x2 - 4 * x4 >= 0)
    model.addConstr(16 * x1 + 6 * x2 + 16 * x4 <= 128)
    model.addConstr(16 * x1 + 14 * x3 + 16 * x4 <= 182)
    model.addConstr(6 * x2 + 14 * x3 + 16 * x4 <= 73)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Bill: ', x1.varValue)
        print('Hours worked by Ringo: ', x2.varValue)
        print('Hours worked by Dale: ', x3.varValue)
        print('Hours worked by George: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
