
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="airborne_infantry_companies")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="pathfinder_teams")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="logistics_companies")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="water_purification_units")
    x4 = m.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")


    # Set objective function
    m.setObjective(5*x0 + 8*x1 + 5*x2 + 9*x3 + 5*x4, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(x0 + x3 >= 24, "c0")
    m.addConstr(x0 + 2*x4 >= 31, "c1")
    m.addConstr(x0 + 3*x1 + x2 + x3 + 2*x4 >= 31, "c2")
    m.addConstr(x0 + 3*x1 + x2 + x3 + 2*x4 <= 205, "c3")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('airborne_infantry_companies:', x0.x)
        print('pathfinder_teams:', x1.x)
        print('logistics_companies:', x2.x)
        print('water_purification_units:', x3.x)
        print('air_defense_batteries:', x4.x)

    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
