
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
x3 = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
x4 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")
x5 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")

# Objective function
m.setObjective(5*x1 + 8*x2 + 5*x3 + 9*x4 + 5*x5, GRB.MINIMIZE)

# Constraints
m.addConstr(x1 + x4 >= 24, "offensive_capability_1")
m.addConstr(x1 + 2*x5 >= 31, "offensive_capability_2")
m.addConstr(x1 + 3*x2 + x3 + x4 + 2*x5 >= 31, "total_offensive_capability")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Airborne Infantry Companies: {x1.x}")
    print(f"Pathfinder Teams: {x2.x}")
    print(f"Logistics Companies: {x3.x}")
    print(f"Water Purification Units: {x4.x}")
    print(f"Air Defense Batteries: {x5.x}")
else:
    print("No optimal solution found.")
