
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='airborne_infantry_companies', obj=5, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='pathfinder_teams', obj=8, vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='logistics_companies', obj=5, vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='water_purification_units', obj=9, vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name='air_defense_batteries', obj=5, vtype=gurobi.GRB.INTEGER)

    # Add constraints
    model.addConstr(x1 + x4 >= 24, name='offensive_capability_rating_1')
    model.addConstr(x1 + 2*x5 >= 31, name='offensive_capability_rating_2')
    model.addConstr(x1 + 3*x2 + x3 + x4 + 2*x5 >= 31, name='total_offensive_capability_rating')

    # Set the objective function
    model.setObjective(5*x1 + 8*x2 + 5*x3 + 9*x4 + 5*x5, gurobi.GRB.MINIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Airborne Infantry Companies: ', x1.varValue)
        print('Pathfinder Teams: ', x2.varValue)
        print('Logistics Companies: ', x3.varValue)
        print('Water Purification Units: ', x4.varValue)
        print('Air Defense Batteries: ', x5.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
