
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")
    knishes = m.addVar(vtype=gp.GRB.INTEGER, name="knishes")
    granola_bars = m.addVar(vtype=gp.GRB.INTEGER, name="granola_bars")

    # Set objective function
    m.setObjective(8.94 * eggs + 3.39 * knishes + 3.5 * granola_bars, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(29 * eggs + 4 * knishes + 25 * granola_bars >= 38, "calcium_min")
    m.addConstr(16 * knishes + 13 * granola_bars >= 81, "sourness_knishes_granola_min")
    m.addConstr(16 * eggs + 16 * knishes >= 82, "sourness_eggs_knishes_min")
    m.addConstr(16 * eggs + 13 * granola_bars >= 48, "sourness_eggs_granola_min")
    m.addConstr(4 * knishes + 25 * granola_bars <= 98, "calcium_knishes_granola_max")
    m.addConstr(29 * eggs + 25 * granola_bars <= 114, "calcium_eggs_granola_max")
    m.addConstr(29 * eggs + 4 * knishes + 25 * granola_bars <= 114, "calcium_max")
    m.addConstr(16 * eggs + 16 * knishes <= 52, "cost_eggs_knishes_max")
    m.addConstr(16 * eggs + 16 * granola_bars <= 136, "cost_eggs_granola_max")
    m.addConstr(16 * knishes + 16 * granola_bars <= 104, "cost_knishes_granola_max")
    m.addConstr(16 * eggs + 16 * knishes + 16 * granola_bars <= 95, "cost_max")
    m.addConstr(16 * knishes + 13 * granola_bars <= 223, "sourness_knishes_granola_max")
    m.addConstr(16 * eggs + 16 * knishes + 13 * granola_bars <= 292, "sourness_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('eggs:', eggs.x)
        print('knishes:', knishes.x)
        print('granola_bars:', granola_bars.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
