
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    eggs = model.addVar(name="eggs", vtype=gurobi.GRB.INTEGER)
    knishes = model.addVar(name="knishes", vtype=gurobi.GRB.INTEGER)
    granola_bars = model.addVar(name="granola_bars", vtype=gurobi.GRB.INTEGER)
    
    # Objective function
    model.setObjective(8.94 * eggs + 3.39 * knishes + 3.5 * granola_bars, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(29 * eggs + 4 * knishes + 25 * granola_bars >= 38)  # Calcium
    model.addConstr(16 * knishes + 13 * granola_bars >= 81)  # Sourness from knishes and granola bars
    model.addConstr(16 * eggs + 16 * knishes >= 82)  # Sourness from eggs and knishes
    model.addConstr(16 * eggs + 13 * granola_bars >= 48)  # Sourness from eggs and granola bars
    model.addConstr(4 * knishes + 25 * granola_bars <= 98)  # Calcium from knishes and granola bars
    model.addConstr(29 * eggs + 25 * granola_bars <= 114)  # Calcium from eggs and granola bars
    model.addConstr(29 * eggs + 4 * knishes + 25 * granola_bars <= 114)  # Total calcium
    model.addConstr(16 * eggs + 16 * knishes <= 52)  # Cost of eggs and knishes
    model.addConstr(16 * eggs + 16 * granola_bars <= 136)  # Cost of eggs and granola bars
    model.addConstr(16 * knishes + 16 * granola_bars <= 104)  # Cost of knishes and granola bars
    model.addConstr(16 * eggs + 16 * knishes + 16 * granola_bars <= 95)  # Total cost
    model.addConstr(16 * knishes + 13 * granola_bars <= 223)  # Sourness from knishes and granola bars
    model.addConstr(16 * eggs + 16 * knishes + 13 * granola_bars <= 292)  # Total sourness
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Eggs: ", eggs.varValue)
        print("Knishes: ", knishes.varValue)
        print("Granola Bars: ", granola_bars.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
