
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(name='dish_soap_bottles', vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name='paper_towel_rolls', vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name='candles', vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name='diapers', vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(1.01 * x0 + 3.64 * x1 + 1.72 * x2 + 1.49 * x3, gurobi.GRB.MINIMIZE)

# Constraints
# Storage space
model.addConstr(4 * x0 + 7 * x1 + 9 * x2 + 12 * x3 <= 288)
model.addConstr(9 * x2 + 12 * x3 >= 47)
model.addConstr(7 * x1 + 9 * x2 >= 30)
model.addConstr(7 * x1 + 12 * x3 >= 71)
model.addConstr(4 * x0 + 7 * x1 + 9 * x2 + 12 * x3 >= 71)

# Usefulness rating
model.addConstr(11 * x0 + 3 * x2 >= 32)
model.addConstr(3 * x2 + 7 * x3 >= 19)
model.addConstr(15 * x1 + 3 * x2 >= 18)
model.addConstr(11 * x0 + 15 * x1 >= 30)
model.addConstr(15 * x1 + 7 * x3 >= 21)
model.addConstr(11 * x0 + 3 * x2 + 7 * x3 >= 26)
model.addConstr(11 * x0 + 15 * x1 + 3 * x2 >= 26)
model.addConstr(11 * x0 + 3 * x2 + 7 * x3 >= 24)
model.addConstr(11 * x0 + 15 * x1 + 3 * x2 >= 24)
model.addConstr(11 * x0 + 15 * x1 + 3 * x2 + 7 * x3 >= 24)

# Weight
model.addConstr(10 * x0 + 14 * x2 >= 64)
model.addConstr(10 * x0 + 12 * x3 >= 52)
model.addConstr(10 * x0 + 17 * x1 + 14 * x2 >= 61)
model.addConstr(10 * x0 + 17 * x1 + 12 * x3 >= 61)
model.addConstr(17 * x1 + 14 * x2 + 12 * x3 >= 61)
model.addConstr(10 * x0 + 17 * x1 + 14 * x2 >= 37)
model.addConstr(10 * x0 + 17 * x1 + 12 * x3 >= 37)
model.addConstr(17 * x1 + 14 * x2 + 12 * x3 >= 37)
model.addConstr(10 * x0 + 17 * x1 + 14 * x2 >= 55)
model.addConstr(10 * x0 + 17 * x1 + 12 * x3 >= 55)
model.addConstr(17 * x1 + 14 * x2 + 12 * x3 >= 55)
model.addConstr(10 * x0 + 17 * x1 + 14 * x2 + 12 * x3 >= 55)

# Others
model.addConstr(-8 * x1 + 5 * x3 >= 0)
model.addConstr(-x0 + 3 * x3 >= 0)
model.addConstr(4 * x0 + 12 * x3 <= 87)
model.addConstr(9 * x2 + 12 * x3 <= 103)
model.addConstr(4 * x0 + 9 * x2 <= 154)
model.addConstr(7 * x1 + 12 * x3 <= 210)
model.addConstr(4 * x0 + 7 * x1 + 9 * x2 <= 249)
model.addConstr(15 * x1 + 3 * x2 <= 119)
model.addConstr(15 * x1 + 3 * x2 + 7 * x3 <= 127)
model.addConstr(11 * x0 + 15 * x1 + 7 * x3 <= 45)
model.addConstr(11 * x0 + 15 * x1 + 3 * x2 <= 132)
model.addConstr(14 * x2 + 12 * x3 <= 193)
model.addConstr(17 * x1 + 12 * x3 <= 121)
model.addConstr(10 * x0 + 17 * x1 <= 242)
model.addConstr(17 * x1 + 14 * x2 <= 173)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Dish soap bottles: ", x0.varValue)
    print("Paper towel rolls: ", x1.varValue)
    print("Candles: ", x2.varValue)
    print("Diapers: ", x3.varValue)
else:
    print("No solution found")

