
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x = m.addVars(5, lb=0, name=["potassium", "vitamin_B5", "vitamin_B3", "fat", "fiber"])


    # Set objective function
    m.setObjective(7.39 * x[0] + 7.48 * x[1] + 4.63 * x[2] + 5.2 * x[3] + 9.28 * x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8.01 * x[1] + 6.6 * x[3] >= 21, "c1")
    m.addConstr(6.64 * x[2] + 6.6 * x[3] >= 22, "c2")
    m.addConstr(6.6 * x[3] + 6.16 * x[4] >= 8, "c3")
    m.addConstr(4.7 * x[0] + 8.01 * x[1] >= 24, "c4")
    m.addConstr(6.64 * x[2] + 6.16 * x[4] >= 17, "c5")
    m.addConstr(4.7 * x[0] + 6.64 * x[2] >= 18, "c6")
    m.addConstr(4.7 * x[0] + 6.16 * x[4] >= 24, "c7")
    m.addConstr(6.64 * x[2] + 6.16 * x[4] <= 38, "c8")
    m.addConstr(6.64 * x[2] + 6.6 * x[3] <= 81, "c9")
    m.addConstr(8.01 * x[1] + 6.6 * x[3] <= 54, "c10")
    m.addConstr(4.7 * x[0] + 6.16 * x[4] <= 75, "c11")
    m.addConstr(4.7 * x[0] + 8.01 * x[1] <= 31, "c12")
    m.addConstr(4.7 * x[0] + 6.6 * x[3] <= 121, "c13")
    m.addConstr(4.7 * x[0] + 8.01 * x[1] + 6.64 * x[2] + 6.6 * x[3] + 6.16 * x[4] <= 121, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
