
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams of potassium", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams of vitamin B5", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams of vitamin B3", lb=-gp.GRB.INFINITY)
x4 = m.addVar(name="grams of fat", lb=-gp.GRB.INFINITY)
x5 = m.addVar(name="grams of fiber", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(7.39*x1 + 7.48*x2 + 4.63*x3 + 5.2*x4 + 9.28*x5, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(4.7*x1 <= 129)
m.addConstr(8.01*x2 <= 129)
m.addConstr(6.64*x3 <= 129)
m.addConstr(6.6*x4 <= 129)
m.addConstr(6.16*x5 <= 129)

m.addConstr(8.01*x2 + 6.6*x4 >= 21)
m.addConstr(6.64*x3 + 6.6*x4 >= 22)
m.addConstr(6.6*x4 + 6.16*x5 >= 8)
m.addConstr(4.7*x1 + 8.01*x2 >= 24)
m.addConstr(6.64*x3 + 6.16*x5 >= 17)
m.addConstr(4.7*x1 + 6.64*x3 >= 18)
m.addConstr(4.7*x1 + 6.16*x5 >= 24)
m.addConstr(6.64*x3 + 6.16*x5 <= 38)
m.addConstr(6.64*x3 + 6.6*x4 <= 81)
m.addConstr(8.01*x2 + 6.6*x4 <= 54)
m.addConstr(4.7*x1 + 6.16*x5 <= 75)
m.addConstr(4.7*x1 + 8.01*x2 <= 31)
m.addConstr(4.7*x1 + 6.6*x4 <= 121)
m.addConstr(4.7*x1 + 8.01*x2 + 6.64*x3 + 6.6*x4 + 6.16*x5 <= 121)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of potassium: ", x1.varValue)
    print("Milligrams of vitamin B5: ", x2.varValue)
    print("Milligrams of vitamin B3: ", x3.varValue)
    print("Grams of fat: ", x4.varValue)
    print("Grams of fiber: ", x5.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
