
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
    vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")


    # Set objective function
    m.setObjective(3*vitamin_c + 7*calcium + 9*vitamin_b5 + 3*vitamin_a, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.01*vitamin_b5 + 0.43*vitamin_a >= 11, "c0")
    m.addConstr(0.94*calcium + 0.01*vitamin_b5 >= 13, "c1")
    m.addConstr(0.35*vitamin_c + 0.94*calcium >= 24, "c2")
    m.addConstr(0.35*vitamin_c + 0.94*calcium + 0.43*vitamin_a >= 16, "c3")
    m.addConstr(0.35*vitamin_c + 0.94*calcium + 0.01*vitamin_b5 + 0.43*vitamin_a >= 16, "c4")
    m.addConstr(0.65*calcium + 0.81*vitamin_a >= 27, "c5")
    m.addConstr(0.46*vitamin_c + 0.34*vitamin_b5 >= 20, "c6")
    m.addConstr(0.46*vitamin_c + 0.81*vitamin_a >= 14, "c7")
    m.addConstr(0.46*vitamin_c + 0.65*calcium >= 12, "c8")
    m.addConstr(0.46*vitamin_c + 0.65*calcium + 0.34*vitamin_b5 + 0.81*vitamin_a >= 12, "c9")
    m.addConstr(-vitamin_c + 2*calcium >= 0, "c10")
    m.addConstr(0.35*vitamin_c + 0.43*vitamin_a <= 55, "c11")
    m.addConstr(0.35*vitamin_c + 0.01*vitamin_b5 <= 87, "c12")
    m.addConstr(0.35*vitamin_c + 0.94*calcium <= 86, "c13")
    m.addConstr(0.35*vitamin_c + 0.01*vitamin_b5 + 0.43*vitamin_a <= 87, "c14")
    m.addConstr(0.35*vitamin_c + 0.94*calcium + 0.01*vitamin_b5 <= 34, "c15")
    m.addConstr(0.35*vitamin_c + 0.94*calcium + 0.43*vitamin_a <= 78, "c16")
    m.addConstr(0.46*vitamin_c + 0.34*vitamin_b5 + 0.81*vitamin_a <= 39, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
