
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # milligrams of vitamin C
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # milligrams of calcium
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin B5
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin A

    # Objective function
    model.setObjective(3*x0 + 7*x1 + 9*x2 + 3*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.35*x0 + 0.01*x2 + 0.43*x3 >= 11)
    model.addConstr(0.94*x1 + 0.01*x2 >= 13)
    model.addConstr(0.35*x0 + 0.94*x1 >= 24)
    model.addConstr(0.35*x0 + 0.94*x1 + 0.43*x3 >= 16)
    model.addConstr(0.35*x0 + 0.94*x1 + 0.01*x2 + 0.43*x3 >= 16)
    model.addConstr(0.65*x1 + 0.81*x3 >= 27)
    model.addConstr(0.46*x0 + 0.34*x2 >= 20)
    model.addConstr(0.46*x0 + 0.81*x3 >= 14)
    model.addConstr(0.46*x0 + 0.65*x1 >= 12)
    model.addConstr(0.46*x0 + 0.65*x1 + 0.34*x2 + 0.81*x3 >= 12)
    model.addConstr(-x0 + 2*x1 >= 0)
    model.addConstr(0.35*x0 + 0.43*x3 <= 55)
    model.addConstr(0.35*x0 + 0.01*x2 <= 87)
    model.addConstr(0.35*x0 + 0.94*x1 <= 86)
    model.addConstr(0.35*x0 + 0.01*x2 + 0.43*x3 <= 87)
    model.addConstr(0.35*x0 + 0.94*x1 + 0.01*x2 <= 34)
    model.addConstr(0.35*x0 + 0.94*x1 + 0.43*x3 <= 78)
    model.addConstr(0.46*x0 + 0.34*x2 + 0.81*x3 <= 39)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0 (milligrams of vitamin C): {x0.varValue}")
        print(f"x1 (milligrams of calcium): {x1.varValue}")
        print(f"x2 (milligrams of vitamin B5): {x2.varValue}")
        print(f"x3 (milligrams of vitamin A): {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
