
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin A
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B3
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of potassium
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of zinc


# Set objective function
m.setObjective(2.59*x0**2 + 4.81*x0*x1 + 8.51*x0*x3 + 7.14*x1**2 + 3.79*x1*x2 + 7.7*x1*x3 + 2.53*x2**2 + 2.73*x2*x3 + 9.78*x3**2 + 1.78*x1 + 7.84*x2 + 8.26*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x1 + 15*x3 >= 20)
m.addConstr(9*x0 + 9*x2 >= 37)
m.addConstr(9*x0 + 17*x1 + 15*x3 >= 35)
m.addConstr(9*x0 + 9*x2 + 15*x3 >= 35)
m.addConstr(9*x0**2 + 17*x1**2 + 15*x3**2 >= 42)
m.addConstr(9*x0 + 9*x2 + 15*x3 >= 42)
m.addConstr(9*x0 + 17*x1 + 9*x2 + 15*x3 >= 42)
m.addConstr(3*x0**2 + 13*x2**2 >= 77)
m.addConstr(3*x0**2 + 4*x3**2 >= 97)
m.addConstr(7*x1 + 13*x2 >= 93)
m.addConstr(7*x1**2 + 4*x3**2 >= 34)
m.addConstr(7*x1 + 13*x2 + 4*x3 >= 59)
m.addConstr(3*x0**2 + 7*x1**2 + 13*x2**2 >= 59)
m.addConstr(7*x1 + 13*x2 + 4*x3 >= 89)
m.addConstr(3*x0**2 + 7*x1**2 + 13*x2**2 >= 89)
m.addConstr(3*x0 + 7*x1 + 13*x2 + 4*x3 >= 89)
m.addConstr(8*x0**2 - 4*x2**2 >= 0)
m.addConstr(9*x0 + 15*x3 <= 121)
m.addConstr(7*x1 + 13*x2 + 4*x3 <= 193)

# Resource constraints
m.addConstr(9*x0 + 17*x1 + 9*x2 + 15*x3 <= 236) # r0
m.addConstr(3*x0 + 7*x1 + 13*x2 + 4*x3 <= 408) # r1


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

