
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2.59*x0**2 + 4.81*x0*x1 + 8.51*x0*x3 + 7.14*x1**2 + 3.79*x1*x2 + 7.7*x1*x3 + 2.53*x2**2 + 2.73*x2*x3 + 9.78*x3**2 + 1.78*x1 + 7.84*x2 + 8.26*x3)

    # Constraints
    model.addConstr(9*x0 <= 236)
    model.addConstr(3*x0 <= 408)
    model.addConstr(17*x1 <= 236)
    model.addConstr(7*x1 <= 408)
    model.addConstr(9*x2 <= 236)
    model.addConstr(13*x2 <= 408)
    model.addConstr(15*x3 <= 236)
    model.addConstr(4*x3 <= 408)
    model.addConstr(17*x1 + 15*x3 >= 20)
    model.addConstr(9*x0 + 9*x2 >= 37)
    model.addConstr(9*x0 + 17*x1 + 15*x3 >= 35)
    model.addConstr(9*x0 + 9*x2 + 15*x3 >= 35)
    model.addConstr(9*x0**2 + 17*x1**2 + 15*x3**2 >= 42)
    model.addConstr(9*x0 + 9*x2 + 15*x3 >= 42)
    model.addConstr(9*x0 + 17*x1 + 9*x2 + 15*x3 >= 42)
    model.addConstr(3*x0**2 + 13*x2**2 >= 77)
    model.addConstr(3*x0**2 + 4*x3**2 >= 97)
    model.addConstr(7*x1 + 13*x2 >= 93)
    model.addConstr(7*x1**2 + 4*x3**2 >= 34)
    model.addConstr(7*x1 + 13*x2 + 4*x3 >= 59)
    model.addConstr(3*x0**2 + 7*x1**2 + 13*x2**2 >= 59)
    model.addConstr(7*x1 + 13*x2 + 4*x3 >= 89)
    model.addConstr(3*x0**2 + 7*x1**2 + 13*x2**2 >= 89)
    model.addConstr(3*x0**2 + 7*x1**2 + 13*x2**2 + 4*x3**2 >= 89)
    model.addConstr(8*x0**2 - 4*x2**2 >= 0)
    model.addConstr(9*x0 + 15*x3 <= 121)
    model.addConstr(7*x1 + 13*x2 + 4*x3 <= 193)

    model.setAttr(gurobi.GRB.Attr.ModelSense, gurobi.GRB.MINIMIZE)
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No optimal solution found.")

optimize_problem()
