
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="cans_of_coffee")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="planners")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="headsets")


    # Set objective function
    m.setObjective(7*x0 + 9*x1 + x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(23*x0 <= 480, "storage_constraint_coffee")
    m.addConstr(8*x0 <= 392, "sustainability_constraint_coffee")
    m.addConstr(19*x1 <= 480, "storage_constraint_planners")
    m.addConstr(15*x1 <= 392, "sustainability_constraint_planners")
    m.addConstr(24*x2 <= 480, "storage_constraint_headsets")
    m.addConstr(20*x2 <= 392, "sustainability_constraint_headsets")

    m.addConstr(19*x1 + 24*x2 >= 129, "storage_constraint_planners_headsets")
    m.addConstr(23*x0 + 19*x1 >= 138, "storage_constraint_coffee_planners")
    m.addConstr(23*x0 + 19*x1 + 24*x2 >= 138, "storage_constraint_all")

    m.addConstr(8*x0 + 20*x2 >= 108, "sustainability_constraint_coffee_headsets")
    m.addConstr(8*x0 + 15*x1 + 20*x2 >= 108, "sustainability_constraint_all")
    
    m.addConstr(9*x1 - 6*x2 >= 0, "constraint_planners_headsets_relation")
    m.addConstr(19*x1 + 24*x2 <= 419, "storage_constraint_planners_headsets_upper")
    m.addConstr(8*x0 + 15*x1 + 20*x2 <= 218, "sustainability_constraint_all_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
