
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="cans_of_coffee", obj=7, vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="planners", obj=9, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="headsets", obj=1, vtype=gurobi.GRB.INTEGER)

    # Define constraints
    model.addConstr(23*x0 + 19*x1 + 24*x2 <= 480, name="storage_space")
    model.addConstr(8*x0 + 15*x1 + 20*x2 <= 392, name="sustainability_score")
    model.addConstr(19*x1 + 24*x2 >= 129, name="planners_headsets_storage")
    model.addConstr(23*x0 + 19*x1 >= 138, name="coffee_planners_storage")
    model.addConstr(23*x0 + 19*x1 + 24*x2 >= 138, name="total_storage")
    model.addConstr(8*x0 + 20*x2 >= 108, name="coffee_headsets_sustainability")
    model.addConstr(8*x0 + 15*x1 + 20*x2 >= 108, name="total_sustainability")
    model.addConstr(9*x1 - 6*x2 >= 0, name="planners_headsets_constraint")
    model.addConstr(19*x1 + 24*x2 <= 419, name="max_planners_headsets_storage")
    model.addConstr(8*x0 + 15*x1 + 20*x2 <= 218, name="max_sustainability")

    # Set objective function
    model.setObjective(7*x0 + 9*x1 + x2, gurobi.GRB.MINIMIZE)

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Cans of coffee: ", x0.varValue)
        print("Planners: ", x1.varValue)
        print("Headsets: ", x2.varValue)
    else:
        print("Model is infeasible")

solve_optimization_problem()
