
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")


    # Set objective function
    model.setObjective(7*x0**2 + 8*x0*x1 + x0*x2 + 5*x1**2 + 8*x1*x2 + 5*x2**2 + 6*x0 + 3*x1 + 5*x2, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x0 + 4*x1 + 2*x2 <= 138, "c0")
    model.addConstr(7*x0 + 4*x1 + 6*x2 <= 51, "c1")
    model.addConstr(4*x0**2 + 2*x2**2 >= 34, "c2")
    model.addConstr(4*x0**2 + 4*x1**2 >= 43, "c3")
    model.addConstr(4*x0 + 4*x1 + 2*x2 >= 43, "c4")
    model.addConstr(7*x0 + 4*x1 >= 14, "c5")
    model.addConstr(4*x1**2 + 6*x2**2 >= 7, "c6")
    model.addConstr(7*x0**2 + 4*x1**2 + 6*x2**2 >= 15, "c7")
    model.addConstr(7*x0 + 4*x1 + 6*x2 >= 15, "c8")
    model.addConstr(7*x1 - 8*x2 >= 0, "c9")
    model.addConstr(-6*x0 + 6*x1 >= 0, "c10")
    model.addConstr(4*x1 + 6*x2 <= 18, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('granola_bars:', x0.x)
        print('protein_bars:', x1.x)
        print('bananas:', x2.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
