
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="granola_bars", lb=0)
x1 = m.addVar(name="protein_bars", lb=0)
x2 = m.addVar(name="bananas", lb=0)

# Set the objective function
m.setObjective(7*x0**2 + 8*x0*x1 + x0*x2 + 5*x1**2 + 8*x1*x2 + 5*x2**2 + 6*x0 + 3*x1 + 5*x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x0 + 4*x1 + 2*x2 <= 138)
m.addConstr(7*x0 + 4*x1 + 6*x2 <= 51)
m.addConstr(x0**2 + x2**2 >= 34)
m.addConstr(x0**2 + x1**2 >= 43)
m.addConstr(x0 + x1 + x2 >= 43)
m.addConstr(7*x0 + 4*x1 >= 14)
m.addConstr(4*x1**2 + 6*x2**2 >= 7)
m.addConstr(7*x0**2 + 5*x1**2 + 5*x2**2 >= 15)
m.addConstr(7*x0 + 4*x1 + 6*x2 >= 15)
m.addConstr(7*x1 - 8*x2 >= 0)
m.addConstr(-6*x0 + 6*x1 >= 0)
m.addConstr(4*x1 + 6*x2 <= 18)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Granola bars: ", x0.varValue)
    print("Protein bars: ", x1.varValue)
    print("Bananas: ", x2.varValue)
else:
    print("The model is infeasible")
