
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
peggy = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy")


# Set objective function
model.setObjective(6.78 * laura + 6.02 * george + 2.49 * dale + 5.75 * jean + 5.93 * peggy, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * laura + 9 * peggy >= 35)
model.addConstr(4 * laura + 14 * dale >= 62)
model.addConstr(14 * dale + 12 * jean >= 37)
model.addConstr(4 * george + 14 * dale >= 38)
model.addConstr(4 * laura + 12 * jean >= 55)
model.addConstr(14 * dale + 12 * jean + 9 * peggy >= 53)
model.addConstr(4 * george + 14 * dale + 12 * jean >= 53)
model.addConstr(4 * laura + 4 * george + 9 * peggy >= 53)
model.addConstr(4 * laura + 4 * george + 12 * jean >= 53)
model.addConstr(4 * laura + 12 * jean + 9 * peggy >= 53)
model.addConstr(14 * dale + 12 * jean + 9 * peggy >= 61)
model.addConstr(4 * george + 14 * dale + 12 * jean >= 61)
model.addConstr(4 * laura + 4 * george + 9 * peggy >= 61)
model.addConstr(4 * laura + 4 * george + 12 * jean >= 61)
model.addConstr(4 * laura + 12 * jean + 9 * peggy >= 61)
model.addConstr(14 * dale + 12 * jean + 9 * peggy >= 64)
model.addConstr(4 * george + 14 * dale + 12 * jean >= 64)
model.addConstr(4 * laura + 4 * george + 9 * peggy >= 64)
model.addConstr(4 * laura + 4 * george + 12 * jean >= 64)
model.addConstr(4 * laura + 12 * jean + 9 * peggy >= 64)
model.addConstr(14 * dale + 12 * jean + 9 * peggy >= 39)
model.addConstr(4 * george + 14 * dale + 12 * jean >= 39)
model.addConstr(4 * laura + 4 * george + 9 * peggy >= 39)
model.addConstr(4 * laura + 4 * george + 12 * jean >= 39)
model.addConstr(4 * laura + 12 * jean + 9 * peggy >= 39)
model.addConstr(14 * dale + 12 * jean + 9 * peggy >= 70)
model.addConstr(4 * george + 14 * dale + 12 * jean >= 70)
model.addConstr(4 * laura + 4 * george + 9 * peggy >= 70)
model.addConstr(4 * laura + 4 * george + 12 * jean >= 70)
model.addConstr(4 * laura + 12 * jean + 9 * peggy >= 70)
model.addConstr(4 * laura + 4 * george + 14 * dale + 12 * jean + 9 * peggy >= 70)
model.addConstr(7 * laura - 7 * jean >= 0)
model.addConstr(5 * laura - 2 * dale >= 0)
model.addConstr(12 * jean + 9 * peggy <= 158)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

