
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='hours_worked_by_Laura', lb=0)
    x2 = model.addVar(name='hours_worked_by_George', lb=0)
    x3 = model.addVar(name='hours_worked_by_Dale', lb=0)
    x4 = model.addVar(name='hours_worked_by_Jean', lb=0)
    x5 = model.addVar(name='hours_worked_by_Peggy', lb=0, integrality=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6.78 * x1 + 6.02 * x2 + 2.49 * x3 + 5.75 * x4 + 5.93 * x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x1 + 9 * x5 >= 35)
    model.addConstr(4 * x1 + 14 * x3 >= 62)
    model.addConstr(14 * x3 + 12 * x4 >= 37)
    model.addConstr(4 * x2 + 14 * x3 >= 38)
    model.addConstr(4 * x1 + 12 * x4 >= 55)
    model.addConstr(14 * x3 + 12 * x4 + 9 * x5 >= 53)
    model.addConstr(4 * x2 + 14 * x3 + 12 * x4 >= 53)
    model.addConstr(4 * x1 + 4 * x2 + 9 * x5 >= 53)
    model.addConstr(4 * x1 + 4 * x2 + 12 * x4 >= 53)
    model.addConstr(4 * x1 + 12 * x4 + 9 * x5 >= 53)
    model.addConstr(14 * x3 + 12 * x4 + 9 * x5 >= 61)
    model.addConstr(4 * x2 + 14 * x3 + 12 * x4 >= 61)
    model.addConstr(4 * x1 + 4 * x2 + 9 * x5 >= 61)
    model.addConstr(4 * x1 + 4 * x2 + 12 * x4 >= 61)
    model.addConstr(4 * x1 + 12 * x4 + 9 * x5 >= 61)
    model.addConstr(14 * x3 + 12 * x4 + 9 * x5 >= 64)
    model.addConstr(4 * x2 + 14 * x3 + 12 * x4 >= 64)
    model.addConstr(4 * x1 + 4 * x2 + 9 * x5 >= 64)
    model.addConstr(4 * x1 + 4 * x2 + 12 * x4 >= 64)
    model.addConstr(4 * x1 + 12 * x4 + 9 * x5 >= 64)
    model.addConstr(14 * x3 + 12 * x4 + 9 * x5 >= 70)
    model.addConstr(4 * x2 + 14 * x3 + 12 * x4 >= 70)
    model.addConstr(4 * x1 + 4 * x2 + 9 * x5 >= 70)
    model.addConstr(4 * x1 + 4 * x2 + 12 * x4 >= 70)
    model.addConstr(4 * x1 + 12 * x4 + 9 * x5 >= 70)
    model.addConstr(4 * x1 + 4 * x2 + 14 * x3 + 12 * x4 + 9 * x5 >= 70)
    model.addConstr(7 * x1 - 7 * x4 >= 0)
    model.addConstr(5 * x1 - 2 * x3 >= 0)
    model.addConstr(12 * x4 + 9 * x5 <= 158)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Laura: ', x1.varValue)
        print('Hours worked by George: ', x2.varValue)
        print('Hours worked by Dale: ', x3.varValue)
        print('Hours worked by Jean: ', x4.varValue)
        print('Hours worked by Peggy: ', x5.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
